/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mcreator.desertsanddunes.init.DesertsAndDunesModBlocks;
import net.mcreator.desertsanddunes.world.biome.BloomingDesertBiome;
import net.mcreator.desertsanddunes.world.biome.CactusMeadowBiome;
import net.mcreator.desertsanddunes.world.biome.DesertCoastBiome;
import net.mcreator.desertsanddunes.world.biome.DesertDunesBiome;
import net.mcreator.desertsanddunes.world.biome.DesertPlainsBiome;
import net.mcreator.desertsanddunes.world.biome.DryRedDesertPlainsBiome;
import net.mcreator.desertsanddunes.world.biome.DryRedRockDesertValleyBiome;
import net.mcreator.desertsanddunes.world.biome.DryRockDesertValleyBiome;
import net.mcreator.desertsanddunes.world.biome.JoshuaPlainsBiome;
import net.mcreator.desertsanddunes.world.biome.PaloVerdeSavannaBiome;
import net.mcreator.desertsanddunes.world.biome.RedDesertDunesBiome;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class DesertsAndDunesModBiomes {
    public static final DeferredRegister<Biome> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"deserts_and_dunes");
    public static final RegistryObject<Biome> DESERT_DUNES = REGISTRY.register("desert_dunes", DesertDunesBiome::createBiome);
    public static final RegistryObject<Biome> DESERT_PLAINS = REGISTRY.register("desert_plains", DesertPlainsBiome::createBiome);
    public static final RegistryObject<Biome> DESERT_COAST = REGISTRY.register("desert_coast", DesertCoastBiome::createBiome);
    public static final RegistryObject<Biome> RED_DESERT_DUNES = REGISTRY.register("red_desert_dunes", RedDesertDunesBiome::createBiome);
    public static final RegistryObject<Biome> DRY_RED_DESERT_PLAINS = REGISTRY.register("dry_red_desert_plains", DryRedDesertPlainsBiome::createBiome);
    public static final RegistryObject<Biome> DRY_ROCK_DESERT_VALLEY = REGISTRY.register("dry_rock_desert_valley", DryRockDesertValleyBiome::createBiome);
    public static final RegistryObject<Biome> DRY_RED_ROCK_DESERT_VALLEY = REGISTRY.register("dry_red_rock_desert_valley", DryRedRockDesertValleyBiome::createBiome);
    public static final RegistryObject<Biome> BLOOMING_DESERT = REGISTRY.register("blooming_desert", BloomingDesertBiome::createBiome);
    public static final RegistryObject<Biome> JOSHUA_PLAINS = REGISTRY.register("joshua_plains", JoshuaPlainsBiome::createBiome);
    public static final RegistryObject<Biome> CACTUS_MEADOW = REGISTRY.register("cactus_meadow", CactusMeadowBiome::createBiome);
    public static final RegistryObject<Biome> PALO_VERDE_SAVANNA = REGISTRY.register("palo_verde_savanna", PaloVerdeSavannaBiome::createBiome);

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.m_206579_().m_175515_(Registry.f_122818_);
        Registry biomeRegistry = server.m_206579_().m_175515_(Registry.f_122885_);
        WorldGenSettings worldGenSettings = server.m_129910_().m_5961_();
        for (Map.Entry entry : worldGenSettings.m_204655_().m_6579_()) {
            DimensionType dimensionType = (DimensionType)((LevelStem)entry.getValue()).m_204521_().m_203334_();
            if (dimensionType != dimensionTypeRegistry.m_123013_(BuiltinDimensionTypes.f_223538_)) continue;
            ChunkGenerator chunkGenerator = ((LevelStem)entry.getValue()).m_63990_();
            BiomeSource biomeSource = chunkGenerator.m_62218_();
            if (biomeSource instanceof MultiNoiseBiomeSource) {
                MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
                ArrayList<Pair> parameters = new ArrayList<Pair>(noiseSource.f_48435_.m_186850_());
                for (Climate.ParameterPoint parameterPoint : DesertDunesBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DESERT_DUNES.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : DesertPlainsBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DESERT_PLAINS.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : DesertCoastBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DESERT_COAST.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : RedDesertDunesBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)RED_DESERT_DUNES.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : DryRedDesertPlainsBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DRY_RED_DESERT_PLAINS.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : DryRockDesertValleyBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DRY_ROCK_DESERT_VALLEY.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : DryRedRockDesertValleyBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DRY_RED_ROCK_DESERT_VALLEY.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : BloomingDesertBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BLOOMING_DESERT.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : JoshuaPlainsBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)JOSHUA_PLAINS.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : CactusMeadowBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CACTUS_MEADOW.getId()))));
                }
                for (Climate.ParameterPoint parameterPoint : PaloVerdeSavannaBiome.PARAMETER_POINTS) {
                    parameters.add(new Pair((Object)parameterPoint, (Object)biomeRegistry.m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PALO_VERDE_SAVANNA.getId()))));
                }
                chunkGenerator.f_62137_ = new MultiNoiseBiomeSource(new Climate.ParameterList(parameters), noiseSource.f_48438_);
                chunkGenerator.f_223020_ = Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(chunkGenerator.f_62137_.m_207840_()), biome -> ((BiomeGenerationSettings)chunkGenerator.f_223021_.apply(biome)).m_47818_(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.f_64318_.m_203334_();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.f_188871_();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            ArrayList<SurfaceRules.RuleSource> surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.f_189697_());
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DESERT_DUNES.getId()), ((Block)DesertsAndDunesModBlocks.DUNE_SAND.get()).m_49966_(), ((Block)DesertsAndDunesModBlocks.DUNE_SAND.get()).m_49966_(), ((Block)DesertsAndDunesModBlocks.HARD_SAND.get()).m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DESERT_PLAINS.getId()), Blocks.f_49992_.m_49966_(), Blocks.f_50062_.m_49966_(), Blocks.f_50062_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DESERT_COAST.getId()), Blocks.f_49992_.m_49966_(), Blocks.f_50062_.m_49966_(), Blocks.f_50062_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)RED_DESERT_DUNES.getId()), ((Block)DesertsAndDunesModBlocks.DUNE_RED_SAND.get()).m_49966_(), ((Block)DesertsAndDunesModBlocks.DUNE_RED_SAND.get()).m_49966_(), ((Block)DesertsAndDunesModBlocks.HARD_RED_SAND.get()).m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DRY_RED_DESERT_PLAINS.getId()), ((Block)DesertsAndDunesModBlocks.DRY_RED_SAND.get()).m_49966_(), Blocks.f_50394_.m_49966_(), Blocks.f_50394_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DRY_ROCK_DESERT_VALLEY.getId()), ((Block)DesertsAndDunesModBlocks.DRY_SAND.get()).m_49966_(), Blocks.f_50062_.m_49966_(), Blocks.f_50062_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)DRY_RED_ROCK_DESERT_VALLEY.getId()), ((Block)DesertsAndDunesModBlocks.DRY_RED_SAND.get()).m_49966_(), Blocks.f_50394_.m_49966_(), Blocks.f_50394_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)BLOOMING_DESERT.getId()), Blocks.f_49992_.m_49966_(), Blocks.f_50062_.m_49966_(), Blocks.f_50062_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)JOSHUA_PLAINS.getId()), Blocks.f_49992_.m_49966_(), Blocks.f_50062_.m_49966_(), Blocks.f_50062_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)CACTUS_MEADOW.getId()), Blocks.f_49992_.m_49966_(), Blocks.f_50062_.m_49966_(), Blocks.f_50062_.m_49966_()));
            surfaceRules.add(1, DesertsAndDunesModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)PALO_VERDE_SAVANNA.getId()), Blocks.f_50440_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_50493_.m_49966_()));
            NoiseGeneratorSettings moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.f_64439_(), noiseGeneratorSettings.f_64440_(), noiseGeneratorSettings.f_64441_(), noiseGeneratorSettings.f_209353_(), SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.f_224370_(), noiseGeneratorSettings.f_64444_(), noiseGeneratorSettings.f_64445_(), noiseGeneratorSettings.f_158533_(), noiseGeneratorSettings.m_209369_(), noiseGeneratorSettings.f_209354_());
            noiseGenerator.f_64318_ = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)groundBlock)), SurfaceRules.m_189390_((BlockState)underwaterBlock)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202171_((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)undergroundBlock))})));
    }
}

